﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace RacetrackSimulator
{
    class Guy
    {
        // Fields
        public int Cash;
        public Bet MyBet;
        public Label MyLabel;
        public RadioButton MyRadioButton;
        public string Name;

        // Methods
        public Guy() { }
        public void ClearBet()
        {
            this.MyBet.Amount = 0;
            this.MyRadioButton.Text = string.Concat(new object[] { this.Name, " ma ", this.Cash, " zł" });
            this.MyLabel.Text = this.Name + " nie postawił zakładu";
        }
        public void Collect(int Winner)
        {
            this.Cash += this.MyBet.PayOut(Winner);
        }


        public bool PlaceBet(int Amount, int Dog)
        {
            Bet bet = new Bet();
            bet.Amount = Amount;
            bet.Dog = Dog;
            bet.Bettor = this;
            this.MyBet = bet;
            if (this.Cash >= this.MyBet.Amount)
            {
                this.UpdateLabels();
                return true;
            }
            return false;
        }

        public void UpdateLabels()
        {
            this.MyRadioButton.Text = string.Concat(new object[] { this.Name, " ma ", this.Cash, " zł" });
            this.MyLabel.Text = this.MyBet.GetDescription();
        }

 

    }

}
